//
// (c) 2020 wesolutions GmbH
// All rights reserved.
//

import QtQuick 2.2
import QtGraphicalEffects 1.0

import wesual.Controls 1.0

Item {
    id : checkBox

    property alias text         : label.text
    property int   checkedState : Qt.Unchecked
    property bool  checked      : false
    property int   iconSize     : 18
    property bool  inList       : false
    property bool  setHover     : false

    signal clicked()

    implicitHeight : iconSize
    implicitWidth  : (text === "") ?
                         box.width : (box.width + label.implicitWidth + 8)
    activeFocusOnTab : true

    // key handling
    Keys.onSpacePressed  : {
        checked = !checked;
        checkBox.clicked();
    }

    QtObject {
        id : p_

        readonly property int animationDuration : 0
    }

    Rectangle {
        id : focusBorder

        width  : label.implicitWidth  + 4
        height : checkBox.iconSize

        anchors.verticalCenter : parent.verticalCenter
        anchors.right : parent.right

        border {
            width : 1
            color : UI.color(UI.PrimaryFocusBorder, 0.4)
        }
        color : UI.color(UI.PrimaryFocusBorder, 0.2)
        visible : false
    }

    Rectangle {
        id : box

        width  : iconSize
        height : iconSize
        color  : UI.color(UI.PrimaryBase)
        border.width : 1
        border.color : UI.color(UI.PrimaryControlBorder)

        Behavior on border.color {
            ColorAnimation { duration : p_.animationDuration }
        }

        Behavior on color {
            ColorAnimation { duration : p_.animationDuration }
        }

        ColorizedImage {
            id : icon

            anchors.verticalCenter   : parent.verticalCenter
            anchors.horizontalCenter : parent.horizontalCenter

            width  : iconSize
            height : iconSize

            sourceSize {
                width  : iconSize
                height : iconSize
            }
            smooth  : true
            source  : "qrc:/controls/icons/check.png"
            color   : UI.color(UI.DropdownIndicatorIcon)
            visible : checkBox.checked
        }

//        HueSaturation {
//            anchors.fill : icon
//            source       : icon
//            saturation   : -1.0
//            lightness    : 0.76
//            visible      : !checkBox.enabled && checked
//        }

//        ColorOverlay {
//            anchors.fill : icon
//            source  : icon
//            cached  : false
//            color   : UI.color(UI.Overlay)
//            visible : checkedState === Qt.PartiallyChecked && checkBox.enabled
//        }
    }

    Text {
        id : label

        text : ""
        font {
            family : UI.fontFamily(UI.PrimaryFont)
            weight : UI.fontWeight(UI.PrimaryFont)
            pixelSize : 14
        }
        color : UI.color(UI.PrimaryTextColor)
        x : box.width + 6
        y : 15 - font.pixelSize
    }

    MouseArea {
        id : mouseArea

        anchors.fill : parent
        hoverEnabled : true
        onClicked    : {
            checked = !checked;

            if (checked)
                checkedState = Qt.Checked
            else
                checkedState = Qt.Unchecked

            checkBox.focus = true;
            checkBox.clicked();
        }
    }

    states: [
        State {
            name : "disabled"
            when : !enabled
            changes : [
                PropertyChanges {
                    target : label
                    color  : UI.color(UI.DisabledText)
                },
                PropertyChanges {
                    target : icon
                    color  : "#D6D6D6"
                },
                PropertyChanges {
                    target : box
                    border.color : UI.color(UI.DisabledBorder)
                }
            ]
        },
        State {
            name: "clicked"
            when: !inList && mouseArea.pressed
            changes : [
                PropertyChanges {
                    target : box;
                    color  : UI.color(UI.PrimaryPress)
                },
                PropertyChanges {
                    target : box
                    border.color : UI.color(UI.CheckBoxRadioButtonBorderPress)
                }
            ]
        },
        State {
            name: "hover_and_activeFocus"
            when: !inList && activeFocus && (mouseArea.containsMouse || setHover)
            changes : [
                PropertyChanges {
                    target : box
                    color  : UI.color(UI.PrimaryHover)
                },
                PropertyChanges {
                    target : box
                    border.color : UI.color(UI.CheckBoxRadioButtonBorderHover)
                },
                PropertyChanges {
                    target: focusBorder
                    visible : label.text.length > 0 ? true : false
                }
            ]
        },
        State {
            name: "activeFocus"
            when: !inList && activeFocus
            changes : [
                PropertyChanges {
                    target : box
                    color  : UI.color(UI.PrimaryHover)
                },
                PropertyChanges {
                    target : box
                    border.color : UI.color(UI.CheckBoxRadioButtonBorderHover)
                },
                PropertyChanges {
                    target: focusBorder
                    visible : label.text.length > 0 ? true : false
                }
            ]
        },
        State {
            name: "hovered"
            when: !inList && (mouseArea.containsMouse || setHover)
            changes : [
                PropertyChanges {
                    target : box
                    color  : UI.color(UI.PrimaryHover)
                },
                PropertyChanges {
                    target : box
                    border.color : UI.color(UI.CheckBoxRadioButtonBorderHover)
                }
            ]
        }
    ]
}
